/**
* \file: UspiInputSource.cpp
*
* \version: $Id:$
*
* \release: $Name:$
*
* Android Auto input component using USPI backend.
*
* \component: Android Auto
*
* \author: P. Acar / ADIT/SW2 / pacar@de.adit-jv.com
*
* \copyright (c) 2016 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/
#include <adit_logging.h>
#include "UspiInputSourceImpl.h"
#include <UspiInputSource.h>

LOG_IMPORT_CONTEXT(aauto_input)

namespace adit { namespace aauto {

UspiInputSource::UspiInputSource(uint8_t inSessionId, MessageRouter* inMessageRouter)
 : AditInputSource(inSessionId, inMessageRouter)
{
    impl = new UspiInputSourceImpl(this, (void*)inMessageRouter);
}

UspiInputSource::~UspiInputSource()
{
    /* Deleted at GalReceiver destruction, impl is registered as a callback and hold in a shared pointer */
//    delete impl;
}

bool UspiInputSource::init()
{
    return impl->init();
}

bool UspiInputSource::shutdown()
{
    return impl->shutdown();
}

void UspiInputSource::setConfigItem(std::string inKey, std::string inValue)
{
    return impl->setConfigItem(inKey, inValue);
}

void UspiInputSource::registerCallbacks(IAditInputSourceCallbacks* inCallbacks)
{
    return impl->registerCallbacks(inCallbacks);
}

} } // namespace adit { namespace aauto {
